/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

VertsA=[[0,0,0],[1,0,0],[0,1,0],[0,0,1],[0.5,0,1],[0,0.5,1]];
Faces=[[0,1,2],[0,1,4,3],[1,2,5,4],[2,0,3,5],[3,4,5]];

VertsB=AffineTransform(ShearingMatrix(Matrix=[[1,0,0],[0,1,-1],[0,0,1]]),VertsA);

module Layer(Z0){
    intersection(){
        translate([-2,-2,Z0])
        cube([10,10,0.1-Smidge]);
        polyhedron(VertsA,Faces);
    }
}

color(RED)
polyhedron(VertsB,Faces);
color(OSG,0.7)
polyhedron(VertsA,Faces);
