/*
  <Img_ShiftKnob.scad>

  Hank J. van Leuvensteijn Jr. 2020
  theghoul@hankjr.ca
 */

include<TheGHOUL/Config.scad>;

// Conventions and Definitions =================================================

/**
 * Planes described viewing the Z=0 plane from the OpenSCAD 'Top' view.
 * Positive X-axis is 'Right, or 3 o'clock'.
 * Positive Y-axis is 'Top, or 12 o'clock'.
 * Progression of points is CCW starting ON positive X-axis.
 * Azimuth angles measured CCW starting from positive X-axis.
 * Inclination angles measured from the positive Z-axis.

 * The PS and NS vectors need to be coaxial if a smooth transition is required at the Tangent Point Plane.

 * At this time the mesh generator requires each TPP to contain the same number of segments, i.e., the same number of Tangent Points.
 **/

/* Tangent Point
   [[Vertex],Inc,Az,1,1,1,1,NV,NS,PV,PS],
   ...
*/

/*
function NAME(  // Tangent Point Plane
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            Tangent Points
        ],
        Transforms
    ]
;
*/

function Three(  // Tangent Point Plane
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[1,0,0],0,0,2,2,5,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,1,0],0,90,2,2,5,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[-1,0,0],0,180,2,2,5,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,-1,0],0,270,2,2,5,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]]
        ],
        Transforms
    ]
;

function Two(  // Tangent Point Plane
        Transforms=[[0,0,0,"T"]],XYS
    )=
    [
        [
            [[15,0,0],90,0,8,8,5,5,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,10,0],90,90,8,6,2,5,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[-10,0,0],80,180,6,6,2,5,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,-10,0],90,270,6,8,2,5,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]]
        ],
        Transforms
    ]
;

function One(  // Tangent Point Plane
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[6,0,0]  ,130,  0,4,4,4,4,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,8,0]  ,110, 90,3,5,5,5,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[-9,0,0],110,180,4,4,4,4,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,-8,0] ,110,270,5,3,4,4,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]]
        ],
        Transforms
    ]
;

function Zero(  // Tangent Point Plane
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[4,0,0],180,0,2.2,2.2,1,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,4,0],180,90,2.2,2.2,1,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[-4,0,0],180,180,2.2,2.2,1,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]],
            [[0,-4,0],180,270,2.2,2.2,1,1,[-1,0,0],[1,0,0],[0,-1,0],[0,1,0]]
        ],
        Transforms
    ]
;

Zero=Zero([[0,0,0,"T"]]);
One=One([[0,0,10,"T"]]);
Two=Two([[0,0,20,"T"]]);
Three=Three([[0,0,28,"T"]]);


Solid=[  // Tangent Point Plane Array
Zero,One,Two,Three];

BCShowTPPlane(One,Curves=[],TPoints=[],CPoints=undef,Vectors=[],UCS=undef,Resolution=50,Cs=0.3,TPs=0.7,CPs=0.6,Vs=0.4,UCSs=6,Cc=OSG,TPc=CPR,CPc=RED);

color(DSG,0.75)
BCPolyhedron(Solid,40);
