/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* Some conditions. */
$AnimSegs=10;
$vpt=[0,0,6];$vpr=[70,0,40];$vpd=60;
$fn=100;

/* Thread profile. */
Turns=4;
Diameter=20;
Pitch=3;
Internal=false;
Angle=60;
Root=1/4;
Crest=1/8;
LeftHanded=false;
BeginHigbee=0.25;
EndHigbee=0.25;
HigbeePower=0.5;

/* The 'helixing' profile slice. */
Prof=[
    [0, Pitch / 2],
    [Pitch / 2 / tan(Angle / 2) * (1-Crest), Pitch / 2 * Crest],
    [Pitch / 2 / tan(Angle / 2) * (1-Crest), -Pitch / 2 * Crest],
    [0, -Pitch / 2]
];
/* It needs a radius position. */
Radius=Diameter/2-Pitch / 2 / tan(Angle / 2) * (1-Crest);
/* Higbee taper scaling factor. */
T=pow(min(1,Turns/BeginHigbee*$t,Turns/EndHigbee*(1-$t)),HigbeePower);
/* Build and position the 'helixing' profile slice. */
color(DSG)
translate([0,0,Pitch*(0.5+Turns*$t)])
rotate([90,0,Turns*360*$t])
translate([Radius,0,-0.250]) // Center the slice.
scale([T,T*1.01,1]) // Higbee scale.
linear_extrude(0.5)
polygon(Prof); // Slice of the profile.

/* Ghost thread. */
color("gold",0.3)
SimpleThread(Turns,Diameter,Pitch,Internal,Angle,Root,Crest,LeftHanded,BeginHigbee,EndHigbee,HigbeePower);

