/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

//$vpt=[0,0,0];$vpr=[6,0,135];$vpd=40;

/* line thickness. */
TNS=0.15;

Crest=1/8;
Root=1/4;
Pitch=10;
Angle=60;
Height=Pitch/2/tan(Angle/2);

A=[0,Pitch/2-Thought];
B=[Height*(1-Crest),Pitch/2*Crest];
C=[Height*(1-Crest),-Pitch/2*Crest];
D=[0,-Pitch/2+Thought];
E=[Height,0];

F=D+[Height,Pitch/2];
G=[Height*(Root-1),-Pitch/2*Root]+[Height,Pitch/2];
H=[Height*(Root-1),Pitch/2*Root]+[Height,Pitch/2];
I=A+[Height,Pitch/2];

IProfile=[F,G,H,I];
RootProfile=[G,A,H];

EProfile=[A,B,C,D];
PeakProfile=[B,E,C];

color("silver",0.2)
linear_extrude(0.1)
polygon(RootProfile);

color("silver")
linear_extrude(0.1)
polygon(IProfile);

color("gold",0.2)
linear_extrude(0.1)
polygon(PeakProfile);

color("gold")
linear_extrude(0.1)
polygon(EProfile);

Dimension(PadTuple(D),PadTuple(A),Type="V",Text=" Pitch",TSize=1,Gap=0.5,TMove=[0,0,0],Decimals=2,Spacing=2,Extension=0.5,Direction="R",Location="A",Thickness=TNS,Marks="A",MSize=0.5,TSpacing=1,Outside=false);

Dimension(PadTuple(D),PadTuple(E),Type="H",Text="Height",TSize=1,Gap=0.5,TMove=[0,0,0],Decimals=2,Spacing=2,Extension=0.5,Direction="R",Location="B",Thickness=TNS,Marks="A",MSize=0.5,TSpacing=1,Outside=false);

Dimension(PadTuple(B),PadTuple(E),Type="H",Text="Crest",TSize=1,Gap=1.8,TMove=[0,0,0],Decimals=2,Spacing=4,Extension=0.5,Direction="R",Location="B",Thickness=TNS,Marks="A",MSize=0.5,TSpacing=1,Outside=true);

Dimension(PadTuple(A),PadTuple(H),Type="H",Text=" Root",TSize=1,Gap=0.5,TMove=[0,0,0],Decimals=2,Spacing=5,Extension=0.5,Direction="R",Location="A",Thickness=TNS,Marks="A",MSize=0.5,TSpacing=1,Outside=true);

translate([2.5,4.5,6])
rotate([0,45,0])
SimpleText("Internal",1,Thickness=0.1,Center=false,Font="Noto Mono",Spacing=1);

color("silver")
translate([0.5,-0.5,6])
rotate([0,45,0])
SimpleText("External",1,Thickness=0.1,Center=false,Font="Noto Mono",Spacing=1);

color("silver")
translate([12,4.5,6])
SimpleText("Angle",1,Thickness=0.1,Center=false,Font="Noto Mono",Spacing=1);

color(DSG)
ArrowArc(StartAngle=-30,Angle=60,Radius=11,Thickness=TNS,Points=[0.5,0.5],Center=[0,5,0]);
