/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

//rotate([0,(1-$t)*360,0])
rotate([0,0,(1-$t)*360])

    union(){
        CoordinateSystem(Size=20,Thickness=0.4,Points=[0,0.2,1],Polar=false);

        rotate([0,0,180])
        translate([0,0,10])
        SimpleText("Text",2,Thickness=0.3,Center=true,Font="Roboto Slab",Spacing=1);

        rotate([0,0,180])
        translate([0,0,10])
        SimpleCircleText("Clockwise",2,16,Thickness=0.3,Center=true,CW=true,Font="Noto Mono",Spacing=1);

        translate([0,0,10])
        SimpleCircleText("SimpleCircleText()",2,16,Thickness=0.3,Center=true,CW=false,Font="Noto Mono",Spacing=1);

        translate([0,0,2.4])
        rotate([0,0,2.5])
        SimpleBarrelText("Centered",3,20,Helix=30,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=0.8,Raise=0);
        translate([0,0,-1.6])
        rotate([0,0,-2.5])
        SimpleBarrelText("Helix=30",3,20,Helix=30,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=0.8,Raise=0);

        color("silver")
        rotate([0,0,225])
        SimpleBarrelText("The GHOUL",6,20,Helix=0,Thickness=1,Center=true,Font="Roboto Slab",Spacing=1.2,Raise=-0.5,Vert=true);

        rotate([0,0,90]){translate([0,0,3.5])
        SimpleBarrelText("Simple",3,20,Helix=0,Thickness=1,Center=true,Font="Noto Mono",Spacing=0.8,Raise=-0.5);
        translate([0,0,0])
        SimpleBarrelText("Barrel",3,20,Helix=0,Thickness=1,Center=true,Font="Noto Mono",Spacing=0.8,Raise=-0.5);
        translate([0,0,-3.5])
        SimpleBarrelText("Text()",3,20,Helix=0,Thickness=1,Center=true,Font="Noto Mono",Spacing=0.8,Raise=-0.5);}

        color("darkslategrey",0.8)
        cylinder(r=20,h=20,center=true);

        /* Degree symbol I believe... */
        echo(str(chr(176)));
    }
