/* You gotta get The GHOUL. */
include<TheGHOUL/Config.scad>

    $AnimSegs=10;

//$t=0.40;

    /* *$t* is multiplied by *$AnimSegs* to get a cycle over *$AnimSegs* seconds. This is the 'sub-second' fraction. This gives us another linearly progressing parameter _within_ each *$AnimSegs* segment, i.e. *$t_t* varies from 0 to 1 within each second of the animation (each *$AnimSegs* segment is supposed to be 1 second, which is achieved by making *Steps* = *$AnimSegs* x *FPS* in the Animation View in OpenSCAD). */
    $t_t=($t*$AnimSegs)%1;

    Color=Animator([[0,OSG],[1,DOG],[2,DBL],[2,RED],[3,YLW],[4,BLU],[5,DGN],[6,CPR],[7,DOG]]);
    Pitch=Animator([[6,10],[6.5,5,1],[7,10]]);
    ND=Animator([[6,100]]);
    Turns=Animator([[0,1],[1,2,1],[2,0.25],[2.5,0.5,1],[3,2],[3.5,4],[5,4],[5.5,2,1],[7,2+310/360,1]]);
    IT=Animator([[7,90],[7.5,50]]);
    IG=Animator([[0,0,1],[4,0],[4.5,50],[5,0],[6,0],[6.5,40],[7.5,70]]);
    IH=Animator([[7,20],[7.5,10]]);
    /* Here we're using *$t_t* to create a linearly progressing parameter _within_ a second. */
    Rot=Animator([[0,0,1],[2,90*$t_t,1],[3,0],[7,180*$t_t,1],[8,0]]);
    Multi=Animator([[0,1,1],[2,4,1],[3,1]]);
    Tap=Animator([[0,0],[3,0],[3.5,25],[4,0]]);
    Ld=Animator([[0,10],[5,10],[5.5,20],[6,10],[6.5,5],[7,10]]);
    Hi=Animator([[0,0],[1,0],[1.5,30,1],[7.5,10]]);
    Ho=Animator([[0,0],[1.5,0],[2,30,1],[7.5,10]]);

Print([Ld/10,"...",Turns/2]);

    $vpd=Animator([[0,300]]);
    $vpt=[-30,-30,0];
    XRot=Animator([[0,50],[4,50],[5,70],[7,70],[8,50]]);
    $vpr=[XRot,0,135];

    Txt=Animator([[0,"Plain"],[1,"Higbee"],[2,"Multistart"],[3,"Taper"],[4,"Interrupted"],[5,"Lead"],[6,"Food closure"],[7,"Quick coupler"]]);

    rotate([0,0,Rot])
    color(Color)
    Thread(TriangularThread,NominalDiameter=ND,Length=undef,External=true,Turns=Turns,Pitch=Pitch,Lead=Ld,ThreadAngle=undef,Height=undef,TaperAngle=Tap,LeftHanded=false,MultiStart=Multi,HigbeeIn=Hi,HigbeeOut=Ho,Higbee2D=true,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[IT,IG,IH],ConversionFactor=1,Support=true,FN=12,ItemReference="");

    color(CPR)
    ScreenText(Text=Txt,Location=[2.5,6,10],Rotation=[-15,-30,0],Size=1,Thickness=0.07,Color=DSG,_SizeCompensation=40);

    ScreenPosition(Location=[2.8,6,8])
    color(DCN)
    rotate([-15,-30,0])
    cube([len(Txt)+0.5,1.5,0.5],center=true);
