/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
  Nothing much that happens here merits explanation. Just read the documentation and comments in the actual routines and functions that are used here if something doesn't make sense or it's not clear to you what happens here.
*/

/* Some settings. */
Form=MetricThread;
Twist=720*$t;
Slide=1.5*Twist/360;

/* Pretty viewpoints. */
MyView=ViewPort([
[0,[0,15,7],[130,0,70],50],
[1.0,[0,15,7],[30,0,90],50],
[2.0,[0,15,7],[270,0,60],50],
[3.0,[0,15,7],[270,0,225],50],
[4.0,[0,15,7],[70,0,60],50],
[5.0,[-7,1.4,4],[80,0,45],10],
[6.0,[-6,-4,3],[60,0,120],10],
[7.0,[-6,-4,3],[60,0,120],45],
[8.0,[-5,15,8],[80,0,60],15],
[9.0,[-5,15,8],[80,0,60],55],
[10.0,[-8,27,9],[120,0,110],12],
[11.0,[-8,17,9],[90,0,90],120],
[12.00,[0,15,7],[130,0,70],50],
]);

$vpt=MyView[1];
$vpr=MyView[2];
$vpd=MyView[3];

translate([0,0,4.5+Slide])
rotate([0,0,Twist])
difference(){
    // External thread
    color("gold",1)
    rotate([0,0,180])
    Thread(Form,10,10);
    color(DSG)
    translate([0,-10,-1])
    cube([20,20,20]);
}

translate([0,0,-Slide])
rotate([0,0,-Twist])
difference(){
    // Internal thread
    color("red",1)
    rotate([0,0,0])
    Thread(Form,10,10,External=false);
    color(DSG)
    translate([0,-10,-1])
    cube([20,20,20]);
}

translate([0,30,5])
rotate([0,0,3])
difference(){
    // Internal thread
    color(RED,1)
    rotate([0,0,140])
    Thread(Form,10,10,External=false);
    color(RED,1)
    translate([0,-10,-1])
    cube([20,20,20]);
}

translate([0,30,0])
rotate([0,0,-3])
difference(){
    // Internal thread support
    color(DSG)
    // re-align support surface n-gon to avoid it's ridges poking through the thread helix, causing ugliness.
    rotate([0,0,6])
    difference(){
        translate([0,0,0.1])
        cylinder(r=6,h=10);
        cylinder(r=5.05413,h=20);
    }
    color(DSG)
    translate([0,-10,-1])
    cube([20,20,20]);
}

translate([0,15,6])
rotate([0,0,-3])
difference(){
    // External thread - solid half
    color("gold",1)
    rotate([0,0,40])
    Thread(Form,10,10);
    color("gold",1)
    translate([0,-10,-1])
    cube([20,20,20]);
}

translate([0,15,0])
rotate([0,0,3])
difference(){
    // External thread support
    color(DSG)
    // re-align support surface n-gon to avoid it's ridges poking through the thread helix, causing ugliness.
    rotate([0,0,-6])
    cylinder(r=4.0798,h=10);
    color(DSG)
    translate([0,-10,-1])
    cube([20,20,20]);
}

translate([0,15,6])
rotate([0,0,-3])
difference(){
    // External thread - transparent half
    color("gold",0.4)
    rotate([0,0,40])
    Thread(Form,10,10);
    color("gold",1)
    translate([-20,-10,-1])
    cube([20,20,20]);
}
