/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/
include<TheGHOUL/Config.scad>

$Debug=false;
$Verbose=false;
// garden hose fittings
sep = 1.5; // use this to separate the individual parts [0] = assembled [1.5] looks good :-)

// all lines with 0-indent can be removed or commented out to get rid of the 'cut-away-cubes'

// male fitting with fixed barbed shank
    color("blue")
    translate([0, 0, -1/16])
    difference(){
        union(){
            translate([0, 0, 1/16])
            Thread(GardenHoseThread,undef,Length=undef,External=true,Turns=4.25,Pitch=undef,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=30,Higbee2D=false,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false,_Quiet=true);
            cylinder(r=0.47477, h=9/16, $fn=100);                           // supporting stub
            translate([0, 0, 9/16])
            intersection(){                                                 // 1-1/8" hex
                cylinder(r=0.64952, h=3/8, $fn=6);
                cylinder(r1=0.47477, r2=0.47477+1, h=4/8, $fn=100);
                translate([0, 0, -1/8])
                cylinder(r2=0.47477, r1=0.47477+1, h=4/8, $fn=100);
            }
            for(i=[0:3]){                                                   // barbed shank
                translate([0, 0, 15/16+i*1/4])
                cylinder(r1=3/8, r2=11/32, h=1/4, $fn=100);
            }
        }
        translate([0, 0, -1/16])
        cylinder(r=25/64, h=7/8, $fn=100);                                  // cut stub core
        cylinder(r=9/32, h=3, $fn=100);                                     // cut shank core
translate([0.003, 0.003, -1/16])
cube([1,1,1+1/4]);
    }


// female swivel
    color("red")
    translate([sep, 0, 0])
    difference(){
        union(){
            intersection(){ // 1-1/4" hex
                cylinder(r=0.72169, h=4/8, $fn=6);
                cylinder(r1=0.53625, r2=0.53625+1, h=4/8, $fn=100);
                translate([0, 0, -2/32])
                cylinder(r2=0.53625, r1=0.53625+1, h=4/8, $fn=100);
            }
            translate([0, 0, -5/16])
            cylinder(r=0.53625+5/64, h=1/2, $fn=100);
        }
        rotate([0, 0, 180])
        Thread(GardenHoseThread,undef,Length=undef,External=false,Turns=4.25,Pitch=undef,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=30,Higbee2D=false,RootClearance=undef,Clearance=0.002,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true,_Quiet=true);
            translate([0, 0, -1/8])
            cylinder(r=0.53625, h=1/8+Smidge, $fn=100);                        // cut hex core
            translate([0, 0, -7/32])
            cylinder(r=0.47477, h=1/8, $fn=100);                        // cut shank ledge
            translate([0, 0, -3/8])
            cylinder(r=0.47477-1/16, h=1/4, $fn=100);                   // cut shank hole
translate([0, 0, -sep-0.5])
cube([1,1,3]);
        }



// washer
    translate([2*sep, 0, 1/1024])// 1/1024 = cut face interference pattern avoidance
    color("brown")
    translate([0, 0, -1/8])
    difference(){
        cylinder(r=0.53625-1/64, h=3/32, $fn=100);                          // washer
        translate([0, 0, -1/64])
        cylinder(r=5/16, h=4/32, $fn=100);                                  // cut hole
translate([0.001, 0.001, -1/2])
cube([1,1,1]);
    }

// barbed shank for female swivel
    translate([3*sep, 0, 0])
    color("green")
    difference(){
        union(){
            for(i=[0:3]){                                                   // barbed shank
                translate([0, 0, -9/16-i*1/4])
                cylinder(r2=3/8, r1=11/32, h=1/4, $fn=100);
            }
            translate([0, 0, -7/32])
            cylinder(r=0.47477-1/64, h=3/32, $fn=100);                      // shank extension
            translate([0, 0, -5/16])
            cylinder(r=0.47477-5/64, h=5/32, $fn=100);                      // shank rim
        }
        translate([0, 0, -2])
        cylinder(r=9/32, h=2, $fn=100);                                     // cut shank core
translate([0.002, 0.002, -1/2])
cube([1,1,1]);
    }

