/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
$vpt=[0,0,0];
$vpr=[45,0,45];
$vpd=30;
*/
Teeth=12;

/*
Echo([GTPCD(Teeth,Type="GT3-2")]);
*/
Pitch=2;


difference(){
    rotate([0,0,30*$t-150])
    translate([0,0,-0.5])
    CircularArray(0.01,150,6)
    linear_extrude(1,convexity=10)
    GTTooth(Teeth,Type="GT3-2",Clearance=0);

    translate([0,0,-1])
    cube([5,5,2]);
    rotate([0,0,60])
    translate([-5,0,-1])
    cube([5,5,2]);
}


difference(){
    translate([GTPCD(Teeth,Type="GT3-2")/2,2*$t-2,-0.5])
    LinearArray(Spacing=[0,BeltData("GT3-2")[0],0],Number=[1,6,1],Center=false)
    linear_extrude(1,convexity=10)
    GTTooth(Teeth=0,Type="GT3-2",Clearance=0);

    translate([0,-5,-1])
    cube([5,5,2]);
}


difference(){
    rotate([0,0,-120])
    translate([GTPCD(Teeth,Type="GT3-2")/2,-10+2*$t,-0.5])
    LinearArray(Spacing=[0,BeltData("GT3-2")[0],0],Number=[1,6,1],Center=false)
    linear_extrude(1,convexity=10)
    GTTooth(Teeth=0,Type="GT3-2",Clearance=0);

    rotate([0,0,60])
    translate([-5,-5,-1])
    cube([5,5,2]);
}


rotate([0,0,30*$t])
color("darkslategrey",0.9)
translate([0,0,Smidge])
GTPulley(Teeth,Width=1,Type="GT3-2");


