/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

VPT=[0,[0,0,1],[45,0,360*$t],15];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

include<TheGHOUL/Config.scad>

module DCube(){
    linear_extrude(height=2,scale=[0.5,0.5])
    square([2,2]);
}

DCube();

color(RED,0.4)
multmatrix(TransformMatrix([[[1,0,1],[0,1,0.5],[0,0,1],"SH"]]))
DCube();

// Funky 'identical row' result from shearing and scaling mix.
// Equivalent to: TransformMatrix([[[-1,0.5,0],[-1,0.5,0],[0,0,1],"SH"]])
color(PRP)
multmatrix(TransformMatrix([[[1,-0.5,0],[-2,1,0],[0,0,1],"SH"],[-1,0.5,1,"S"]]))
DCube();

Echo([TransformMatrix([[[1,-0.5,0],[-2,1,0],[0,0,1],"SH"],[-1,0.5,1,"S"]])]);

color(GRN,0.4)
multmatrix(TransformMatrix([[0,-60,0,"R"]]))
DCube();

color(BLU,0.4)
multmatrix(TransformMatrix([[-0.75,-0.75,1,"T"]]))
DCube();
