/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

Azimuth=45;
Inclination=120;

L=10;
Vz=UnitVector([cos(Azimuth)*sin(Inclination),sin(Azimuth)*sin(Inclination),cos(Inclination)])*L;
Vx=LPerpVector(Vz)*L;
Vy=UnitVector(CrossProduct(Vz,Vx))*L;

color("blue")
Arrow(Vz,Base=Vz,Points=[0,0.4,1],Thickness=1);
color("red")
Arrow(Vx,Base=Vz,Points=[0,0.4,1],Thickness=1);
color("cyan")
Arrow(-Vx,Base=Vz,Points=[0,0.4,1],Thickness=1);

color("green")
Arrow(Vy,Base=Vz,Points=[0,0.4,1],Thickness=1);
color("magenta")
Arrow(-Vy,Base=Vz,Points=[0,0.4,1],Thickness=1);

color(CPR)
sphere(r=L);

ShowVertex(Vz,1,OSG);
