/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/
include<TheGHOUL/Config.scad>

// Declare the animation length:
$AnimSegs=10;

// See GHOUL/Lib/Animation/ViewPorts.scad for info.
// Define the ViewPorts sequence:
MyViewPorts=[
    [0,[0,0,0],[60,0,45],25],
    [1.0,[0,0,0],[60,0,90],200],
    [2.0,[0,0,0],[60,0,135],200],
    [3.0,[0,0,0],[135,0,225],200],
    [4.0,[0,0,0],[90,0,270],100],
    [5.0,[0,0,0],[90,0,0],150],
    [6.0,[20,0,0],[90,0,0],150],
    [7.0,[20,0,0],[0,0,0],150],
    [8.0,[20,0,0],[0,0,180],50],
    [9.0,[20,0,0],[0,0,360],150],
    /* Instead of replicating the first ($t=0) ViewPort, like it is done below, you can simply omit it, and ViewPorts() will cycle back to the first ViewPort, as long as the last specified time (in the case here 9.0) is less than $AnimSegs (which is 10.0 here). */
    [10.0,[0,0,0],[60,0,45],25]
];

// Generate the ViewPort parameters:
MyView=ViewPort(MyViewPorts);

// Then do this:
$vpt=MyView[1];
$vpr=MyView[2];
$vpd=MyView[3];

// Something to look at:
cube([20,20,20]);
Animate(AnimVector=[0,0,10,10])
color("red",$AnFlash)
sphere(r=10*$AnFlash);

// In OpenSCAD select 'View' -> 'Animate' and at the bottom of the window
// set 'Steps' to 200 and 'FPS' to 10, and watch the magic...
