/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

/*******************************************************************************
  This file accompanies the Worked Example on the Bézier curves page in The GHOUL's documentation, therefore the documentation in this file is sparse to non-existent... If you don't have The GHOUL's documentation, go get it at hankjr.ca, otherwise, check out the documentation in the files in the Bézier Curves directory.
*******************************************************************************/

include<TheGHOUL/Config.scad>

/*
function NAME(// Tangent Point Plane
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[],[1,90, 90],[],[1,0,0]],
            [[],[1,90,180],[],[1,0,0]],
            [[],[1,90,270],[],[1,0,0]],
            [[],[1,90,  0],[],[1,0,0]]
        ],
        Transforms
    ]
;
*/

/*******************************************************************************
  Image selector, there are nine images, [0,8].
*******************************************************************************/
Image=4;
/******************************************************************************/
VPT=[0,[0,-12,0],[40,0,30],130];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

// FINAL VERSION  and  image 1 and 2 ===========================================

function Bottom0(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 10,  0,0],[7,90,125],[5      ],[3,90, 60],[0]],
            [[  0,  0,0],[3,90,115],[3,90,65],[3,90, 90],[0]],
            [[-10,  0,0],[5,90,235],[7      ],[3,90,120],[0]],
            [[  0,-15,0],[1,90,  0],[       ],[9,90,270],[0]]
        ],
        Transforms
    ]
;

function Middle0(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 20,  0,0],[12,90,125],[15      ],[10,0,0]],
            [[  0,  0,0],[ 6,90,115],[ 6,90,65],[10,0,0]],
            [[-20,  0,0],[15,90,235],[12      ],[10,0,0]],
            [[  0,-30,0],[ 2,90,  0],[        ],[ 6,0,0]]
        ],
        Transforms
    ]
;

function Top0(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 2, 0,0],[1,90,125],[1      ],[0,0,0],[10,90, 35]],
            [[ 0, 0,0],[1,90,115],[1,90,65],[0,0,0],[ 6,90, 90]],
            [[-2, 0,0],[1,90,235],[1      ],[0,0,0],[10,90,145]],
            [[ 0,-2,0],[1,90,  0],[1      ],[0,0,0],[15,90,270]]
        ],
        Transforms
    ]
;

Heart0=
    [// Tangent Point Plane Array
        Bottom0([[0,-5,-10,"T"]]),
        Middle0([[0,0,0,"T"]]),
        Top0([[0,-10,10,"T"]])
    ]
;

// Heart0.gif (animation) ++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart0(){

    Tumble([180+180*sin(360*$t),90+90*sin(360*$t),0*$t],1)
    translate([0,10,0])
    BezierSolid(Heart0,20);
}

// Heart1.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart1(){

    ShowTPA(Heart0,Sets=[1],Points=undef,Vectors=[],Curves=undef,Closed=true,Radius=1,Thickness=1,Resolution=30,Connect=true,CColor=MGT,PColor=CPR);
}

// Heart2.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart2(){

    ShowTPA(Heart0,Sets=[1],Points=undef,Vectors=[2],Curves=undef,Closed=true,Radius=1,Thickness=1,Resolution=30,Connect=true,CColor=MGT,PColor=CPR);

    color(DSG)
    translate(Middle0()[0][2][0]+[6,-3,0])
    rotate($vpr)
    rotate([15,30,0])
    SimpleText("TP2",2,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=1);
}

// Image 3 =====================================================================

function Middle3(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 20,  0,0],[1,90, 90],[],[1,0,0]],
            [[  0,  0,0],[1,90,180],[],[1,0,0]],
            [[-20,  0,0],[1,90,270],[],[1,0,0]],
            [[  0,-30,0],[1,90,  0],[],[1,0,0]]
        ],
        Transforms
    ]
;

// Heart3.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart3(){

    ShowTPA([Middle3()],Sets=undef,Points=undef,Vectors=undef,Curves=undef,Closed=true,Radius=1,Thickness=1,Resolution=30,Connect=true,CColor=MGT,PColor=CPR);
}

// Image 4 =====================================================================

function Middle4(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 20,  0,0],[10,90, 90],[],[1,0,0]],
            [[  0,  0,0],[10,90,180],[],[1,0,0]],
            [[-20,  0,0],[10,90,270],[],[1,0,0]],
            [[  0,-30,0],[10,90,  0],[],[1,0,0]]
        ],
        Transforms
    ]
;

// Heart4.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart4(){

    ShowTPA([Middle4()],Sets=undef,Points=undef,Vectors=undef,Curves=undef,Radius=1,Thickness=1,Resolution=30,Connect=true,CColor=MGT,PColor=CPR);

    color(RED,0.2)
    linear_extrude(0.1)
    BezierShape([Middle4()]);
}

// Image 5 =====================================================================

function Middle5(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 20,  0,0],[12,90,125],[15      ],[1,0,0]],
            [[  0,  0,0],[ 6,90,115],[ 6,90,65],[1,0,0]],
            [[-20,  0,0],[15,90,235],[12      ],[1,0,0]],
            [[  0,-30,0],[ 2,90,  0],[        ],[1,0,0]]
        ],
        Transforms
    ]
;

// Heart5.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart5(){

    ShowTPA([Middle5()],Sets=undef,Points=undef,Vectors=undef,Curves=undef,Closed=true,Radius=1,Thickness=1,Resolution=30,Connect=true,CColor=MGT,PColor=CPR);

    color(RED,0.2)
    linear_extrude(0.1)
    BezierShape([Middle0()]);
}

// Image 6 =====================================================================
// Heart6.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart6(){

    color(RED)
    linear_extrude(10)
    BezierShape([Middle0()]);
}

// Image 7 =====================================================================
function Bottom7(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 10,  0,0],[12,90,125],[15      ],[1,0,0]],
            [[  0,  0,0],[ 6,90,115],[ 6,90,65],[1,0,0]],
            [[-10,  0,0],[15,90,235],[12      ],[1,0,0]],
            [[  0,-15,0],[ 2,90,  0],[        ],[1,0,0]]
        ],
        Transforms
    ]
;

function Middle7(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 20,  0,0],[12,90,125],[15      ],[1,0,0]],
            [[  0,  0,0],[ 6,90,115],[ 6,90,65],[1,0,0]],
            [[-20,  0,0],[15,90,235],[12      ],[1,0,0]],
            [[  0,-30,0],[ 2,90,  0],[        ],[1,0,0]]
        ],
        Transforms
    ]
;

function Top7a(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 2, 0,0],[12,90,125],[15      ],[1,0,0]],
            [[ 0, 0,0],[ 6,90,115],[ 6,90,65],[1,0,0]],
            [[-2, 0,0],[15,90,235],[12      ],[1,0,0]],
            [[ 0,-2,0],[ 2,90,  0],[        ],[1,0,0]]
        ],
        Transforms
    ]
;

function Top7(
        Transforms=[[0,0,0,"T"]]
    )=
    [
        [
            [[ 2, 0,0],[1,90,125],[1      ],[0,0,0],[1,90, 35]],
            [[ 0, 0,0],[1,90,115],[1,90,65],[0,0,0],[1,90, 90]],
            [[-2, 0,0],[1,90,235],[1      ],[0,0,0],[1,90,145]],
            [[ 0,-2,0],[1,90,  0],[1      ],[0,0,0],[1,90,270]]
        ],
        Transforms
    ]
;

Heart7=
    [// Tangent Point Plane Array
        Bottom7([[0,-5,-10,"T"]]),
        Middle7([[0,0,0,"T"]]),
        Top7a([[0,-10,10,"T"]])
    ]
;

// Heart7.gif (animation) ++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart7(){

    rotate([0,360*$t,0]){
        ShowTPA(Heart7,Sets=undef,Points=undef,Vectors=undef,Curves=undef,Closed=true,Radius=0.5,Thickness=0.5,Resolution=30,Connect=true);

        color(RED,0.5)
        BezierSolid(Heart7,20);
    }
}

$AnimSegs=10;
// Heart8.png ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
module Heart8(){

    Alpha=Animator([[0,0.1],[4,0.1],[5,1],[9,1],[10,0]]);
    Blpha=Animator([[0,1],[4,1],[5,0.4],[9,0.4],[10,1]]);

    translate([0,-11,0])
    rotate([0,0,360*$t])
    rotate([0,360*$t,0])
    translate([0,11,0])
    {
        Animate(AnimVector=[4,10,10])
        ShowTPA(Heart0,Sets=undef,Points=undef,Vectors=undef,Curves=undef,Closed=true,Radius=0.5,Thickness=0.5,Resolution=30,Connect=true,CAlpha=Alpha,VAlpha=Alpha);

        color(RED,Blpha)
        BezierSolid(Heart0,20);
    }
}

if(Image==0) Heart0();
if(Image==1) Heart1();
if(Image==2) Heart2();
if(Image==3) Heart3();
if(Image==4) Heart4();
if(Image==5) Heart5();
if(Image==6) Heart6();
if(Image==7) Heart7();
if(Image==8) Heart8();

