/*
  The general case Animation fraction as a function of the 'AnimVector'.

  The special variables declared by 'Animate()' can be used by 'children()' modules to vary size, position, color, alpha etc. of their objects.

  A sphere that bounces past it's final size and comes back:
  | Animate([2,2,3,7]) sphere(r=$AnBounce);

  A cylinder that bumps against it's final size and grows back:
  | Animate([2,2,3,7]) cylinder(r=1, h=$AnBump);

  A cube that fades into view:
  | Animate([2,2,3,7]) color("red", alpha=$AnAlpha) cube([1,1,1]);

  A cube that pulses color:
  | Animate([0,0,3,7]) color("red", alpha=0.3+0.7*$AnPulse) cube([1,1,1]);

  A cube that rotates back and forth over 120 degrees:
  | Animate([2,2,3,7]) rotate([0,0,120*$AnPulse]) cube([1,1,1]);

  The possibilities are endless.
*/

/*
  AnimVector            :   [Create,Start,Finish,Delete] where Create Start,
                            Finish, and Delete are times in $AnimSegs (see text file in this directory). The animation of an object--unsurprisingly--starts at Start, finishes at Finish. If the time is before Start or after Delete, the object is _not_ generated.
  Frequency             :   Creates a recurring saw-tooth Factor
                            (slope-up to 1 with a sharp drop-off to 0) with 'Frequency' peaks or cycles per segment, i.e. Frequency=2 will result in two peaks per animation segment.
*/
module Animate(AnimVector,Frequency=1)
{
    /* Slope or 'sawtooth wave'. */
    $AnFrac=AnFxFr(AnimVector,Frequency);
    /* Triangular 'wave'. */
    $AnTrngl=AnFxTr(AnimVector,Frequency);
    /* Square-ish. */
    $AnSqr=AnFxSq(AnimVector,Frequency);

    /* Bump up to 1. */
    $AnBump=AnimationFxTwoSines(AnimVector,0,[1,90,6],[0.8,180,6]);
    /* Bounce over 1. */
    $AnBounce=AnimationFxTwoSines(AnimVector,0,[1,90,6],[1.2,180,6]);
    /* 0.3 to 1. */
    $AnAlpha=AnimationFxTwoSines(AnimVector,0.3,[0.7,90,2],[0,180,1]);
    /* 1 to 0.3. */
    $AnOmega=AnimationFxTwoSines(AnimVector,1,[-0.7,90,2],[0,180,1]);
    /* Sinusoid 0-1-0. */
    $AnFlash=AnimationFxTwoSines(AnimVector,0,[0,90,1],[1,180,2]);
    /* Inverted Flash 1-0-1. */
    $AnDip=AnimationFxTwoSines(AnimVector,1,[0,90,1],[-1,180,2]);
    /* Sinusoid 0.5-0-1-0.5. */
    $AnWobble=AnimationFxTwoCos(AnimVector,0.5,[0,90,1],[-0.5,360,1]);

    /* Continuous Flashing. */
    $AnFlashing=AnimationFxTwoSines(AnimVector,0,[0,90,1],[1,180,2],Frequency);

    /* $AnFrac is -1 before Create, and after Delete, in this case, the child object is _not_ generated. */
    if ($AnFrac>-1)
    children();
}

