/*
  Square 'wave' signal.

  Switches between 0 and 1 between *Start* and *Finish*, Frequency times over the animation (See $AnimSegs).

  AnimVector  : [Create,Start,Finish,Delete], see Animate.scad in this directory.
*/
function AnimationFxSquare(AnimVector=[],Frequency=1)=
    let(
        /* Populate some variables. */
        Now=$t*$AnimSegs,
        Create=AnimVector[0],
        Start=AnimVector[1],
        Finish=AnimVector[2],
        Delete=AnimVector[3]==undef?$AnimSegs:AnimVector[3],
        /* Fraction of object animation at Frequency. */
        Fraction=((Now-Start)/(Finish-Start)*Frequency)%1
    )
    /* Catch negative frequencies. */
    Frequency<0?undef:
    /* Do we exist? */
    Now<Create?-1:
    /* Now we do! */
    Now<Start?0:
    /* Are we changing? */
    Now<Finish?round(1-Fraction):
    Now<Delete?0:
    /* Are we deleted? Giving post-deletion a different value from pre-creation allows for differentiation elsewhere, if desired. */
    -2
;

// Shorthand version:
function AnFxSq(AnimVector,Frequency=1)=
    AnimationFxSquare(AnimVector,Frequency)
;
