/*
  ANOTHER animation function? Yes, I know, I keep writing them until I find the one that makes me happy, I think this may be it... Fingers crossed.

  Time-dependent step trough an array of values or smoothly change between values from segment to segment (in an animation, obvs.).

  See $AnimSegs.txt for documentation on $AnimSegs and animation 'segments'.

  *StepArray* is a list of [Time,Value] pairs. Animator() looks for the first Time that's bigger than TimeNow=$t*$AnimSegs, and returns the interpolated value between this [Time,Value] pair and the previous one, since TimeNow _must_ lie between these two.
  ** Time, strictly: time in segments, but the segments are probably seconds.
  ** Value, scalars, lists of scalars (like a rotation [30,0,45]) or strings.
     Obviously, in the case of a string, there's no interpolation, the TimeNow string is used.
  When *TimeNow* lies outside the defined time-range, i.e. is smaller than the first or larger than the last time entry, the respective value will be used, that is, the first value when it's smaller than the first, and the last when it's larger than the last.

  *Shift* value in segments (see $AnimSegs documentation referred to above), added to TimeNow to enable shifted transitions, i.e. transitions in one variable, let's say color, are phase-shifted from transitions in another variable, say diameter, of an object. To properly use this, you should define *StepArray* up to $AnimSegs+Shift.

  When the *StepArray* entry is a triple, like [TimeX, Value1, Value2], the result will STEP at TimeX from Value1 to Value2.

  Example:
  [[0,4],[3,10,5],[6,5],[7,10],[10,2]]

  0:        Starts at 4
  0...<3:   Increases to 10
  3:        Steps to 5
  3...<6:   Constant at 5
  6...<7:   Increases to 10
  7...<10:  Decreases to 2
*/
function Animator(StepArray,Shift=0)=
    let(
        /* When are we? */
        TimeNow=max(0,$t*$AnimSegs+Shift),
        /* Are we before the beginning of *StepArray*? */
        PreStart=TimeNow<StepArray[0][0],
        /* If TimeNow is before the first time entry in *StepArray*, Previous takes the first value. */
        Previous=PreStart?0
        /* Find last time value before TimeNow. */
        :  FindLTE(TimeNow,StepArray,"Last"),
        /* If TimeNow is before the first time entry in *StepArray*, Next takes the first value. */
        Next=PreStart?0
        /* If Previous is the last time value in *StepArray*, i.e., we're past the end, Next will be the same. */
        :   min(Len(StepArray),Previous+1),
        /* Set times. */
        T1=StepArray[Previous][0],
        T2=StepArray[Next][0],
        /* Set values. If an element contains two values (See intro above) we need the second value; choosing the 'last' value automatically solves that */
        V1=StepArray[Previous][Len(StepArray[Previous])],
        V2=StepArray[Next][1]
    )
    /* Are we dealing with strings or are we beyond the max time in *StepArray* (equal values and times)? */
    (IsString(V1)||(T2==T1))
        /* Use the 'start' value. */
        ?   V1
        // Calculate the intermediate.
        :    Intermediate(V1,V2,(TimeNow-T1)/(T2-T1))
;
