/*
  Along the lines of the CSS implementation.
  https://cubic-bezier.com/
  https://www.w3schools.com/cssref/func_cubic-bezier.asp

  Use with 'Animate()' and $AnFrac

 | Animate([0,4,10])
 | color(DSG,BezierTransitionDown(0,0.5,0.5,0.9,$AnFrac))
 | cube([5,5,5]);

  NOTE: Since the Bézier functions parameter 'Fraction' is NOT equal or even proportional to 'X' (see Bézier Curve construction and de Casteljau algorithm in the TheGHOUL/Lib/Curves directory), the legacy functions were (more than) a little distorted.

  The current functions, at the price of elegance, return the actual Bézier curve coordinates, as expected, and produce the same curves as the CSS 'cubic-bezier()' functions.
*/

/*
  Curve goes from [0,1] to [1,0].
  X-values are clipped to [0:1], Y-values are free, similar to CSS implementation.
*/
function BezierTransitionDown(X1,Y1,X2,Y2,Frac=undef,Res=0.001)=
    let(
        _X1=Clip(X1),
        _X2=Clip(X2),
        _Frac=undef==Frac
            // The default situation is that we're in an animation sequence, i.e., this routine is a child of an 'Animate()' call, $AnFrac is the linear indicator of our relative time-point.
            ?   $AnFrac
            // A non-default case.
            :   Frac
    )
    /* Make sure 0<=_Frac<=1. */
    Clip(_Frac)==_Frac
        // Start the iteration.
        ?   BTCD(_X1,Y1,_X2,Y2,_Frac,Res)
        :   undef
;
/* Recursive helper. */
function BTCD(X1,Y1,X2,Y2,Frac,Res,Inc=0)=
    let(
        VX=CBezierVertex([[0,1],[X1,Y1],[X2,Y2],[1,0]],Inc)
    )
    /* Check if X-coordinate equals/surpasses *Frac* (the 'expexted' outcome). */
    VX.x>=Frac
        /* Return the Y-coordinate. Prevent small 'undershoot' (i.e., negative) values that cause unexpected results. */
        ?   max(0,VX.y)
        // Not close enough, re-iterate
        :   BTCD(X1,Y1,X2,Y2,Frac,Res,Inc+Res)
;
