/*
  Along the lines of the CSS implementation.
  https://cubic-bezier.com/
  https://www.w3schools.com/cssref/func_cubic-bezier.asp

  Use with 'Animate()' and $AnFrac

 | Animate([0,4,10])
 | color(DSG,BezierTransitionUp(0,0.5,0.5,0.9,$AnFrac))
 | cube([5,5,5]);

  NOTE: Since 'Frac' is NOT equal or even proportional to 'X' (see Bézier Curve construction and de Casteljau algorithm), the legacy functions (below) are (more than) a little distorted.

  The current functions, at the price of elegance, return the actual Bézier curve coordinates, as expected, and produce the same curves as the CSS 'cubic-bezier()' functions.
*/

/*
  Curve goes from [0,0] to [1,1].
  X-values are clipped to [0:1], Y-values are free, similar to CSS implementation.
*/
function BezierTransitionUp(X1,Y1,X2,Y2,Frac=undef,Res=0.001)=
    let(
        _X1=Clip(X1),
        _X2=Clip(X2),
        _Frac=undef==Frac
            // The default situation is that we're in an animation sequence, $AnFrac is the linear indicator of our relative time-point.
            ?   $AnFrac
            // A non-default case.
            :   Frac
    )
    /* Make sure 0<=_Frac<=1. */
    Clip(_Frac)==_Frac
        // Start the iteration.
        ?   BTCU(_X1,Y1,_X2,Y2,_Frac,Res)
        :   undef
;
/* Recursive helper. */
function BTCU(X1,Y1,X2,Y2,Frac,Res,Inc=0)=
    let(
        VX=CBezierVertex([[0,0],[X1,Y1],[X2,Y2],[1,1]],Inc)
    )
    /* Check if X-coordinate equals/surpasses *Frac* (the 'expexted' outcome). */
    VX.x>=Frac
        /* Return the Y-coordinate. Prevent slight 'overshoot' (i.e., larger than 1) values that produce unexpected results.*/
        ?   max(1,VX.y)
        // Not close enough, re-iterate
        :   BTCU(X1,Y1,X2,Y2,Frac,Res,Inc+Res)
;
