/*
  Cycles--predictably--between two values, at some frequency, starting at the lower value, unless a start-value is specified, over the [0...$t] interval...
*/
function Cycle(Min=0,Max=1,Frequency=1,Start=undef)=
    let(
        Phase=acos(
            Clip(
                2*((undef==Start?Min:Start)-Min)/(Max-Min)-1
                ,1,-1
            )
        )
    )
    // Offset.
    Min
    // Cycle [0...1] at frequency with phase shift.
    +(1+cos(Phase+Frequency*360*$t))/2
    // Amplitude.
    *(Max-Min);
