/*
  Get the x,y,z domain of a set of points, or the minimum and maximum of a list of values.
  Input:   An array of 3D points.
  Result:  Domain min/max vectors DV=[[Xmin,Ymin,Zmin],[Xmax,Ymax,Zmax]]
           Min Y = DV[0].y
           Max Z = DV[1].z &c.

  Interesting: Instead of 'DV[0][1]' or 'DV[0].y' you actually can do 'DV.x.y'. Who knew?

  If your array is just a 1-dimensional list of values, you can just do max(Array).
 */
 /* TODO: See end of this file. ALSO, this probably stumbles on irregular lists. */
function ArrayDomain(Array)=
    let(
        Domain=is_list(Array[0][0])
        // The array contains arrays, not vertices, flatten and try again.
        ?   ArrayDomain(FlattenArray(Array))
        :   is_list(Array[0])
            ?   [
                    [
                        /* For x,y,z of each element... */
                        for(Idex=[0:Len(Array[0])])
                        /* The minimum. */
                        min([for(Element=Array) Element[Idex]])
                    ],[
                        /* For x,y,z of each element... */
                        for(Jdex=[0:Len(Array[0])])
                        /* The maximum. */
                        max([for(Element=Array) Element[Jdex]])
                    ]
                ]
            :   FlattenArray(ArrayDomain([for(Element=Array)[Element]]))
    )
    Domain
;
