/*
  Product of range of array elements.

  Multiply all elements from *Start* to *End*.
*/
function ArrayProduct(Array,Start=0,End=-1)=
    let(
        $Array=Array,
        // Map negative indices back onto valid range
        _Start=Dex(Start,Len(Array)),
        Foo=Alert(["Start out of range at ",Start,", mapped onto ",_Start,"."],0,abs(Start)>Len(Array)),
        _End=Dex(End,Len(Array)),
        Bar=Alert(["End out of range at ",End,", mapped onto ",_End,"."],0,(abs(End)>Len(Array)&&End!=-1)),
         // Subtract 1 from *_Count* because we're feeding the iterator the *_End* element as a seed for *Result*.
         _Count=_End-_Start-1
    )
    /* Catch sillyness.... */
    _End<_Start
    ?   undef
    :   _ArrayProduct(_Start,_Count,Array[_End])
;

function _ArrayProduct(Sdex,Idex,Result)=
    Idex<0
    ?   Result
    :   _ArrayProduct(Sdex,Idex-1,Result*$Array[Sdex+Idex])
;
