/*
  Sublist of array, Indices can be a list [2,5,8] or a range [2:1:7]. It's not called 'SubArray()' because, unlike 'SubString()', the selected elements don't need to be successive. */
function ArraySelect(Array, Indices)=
    let(
        Lth=Len(Array),
        /* Map out of range indices back into range. */
        _Indices=[
            for(Index=Indices)
                Dex(Index,Lth)
        ],
        /* Alert the user. */
        Foo=Alert(["One or more indices out of range and re-mapped."],0,
            OrIsTrue([
                for(Idex=Indices)
                    Idex>Lth,
                for(Idex=Indices)
                    Idex<0,
            ])
        )
    )
    /* Do the thing. */
    [
        for (Jdex = _Indices)
            Array[Jdex]
    ]
;

