/*
  Find the first element in an array that is Equal to a value.
*/
function FindEQ(Value,Array,Type="First",Element=0)=
    let(
        /* Put some parameters in Special Variables, easier this way than putting them in the recursive calls. */
        $Array=Array,
        $Value=Value
    )
    Type=="First"
    ?   _FindEQFirst(0,Element)
    :   Type=="Last"
        ?   _FindEQLast(Len($Array),Element)
        :   _FindEQAll(Len($Array),Element)
;

/* Recursive helpers. */
function _FindEQFirst(Index,Element)=
    Index==len($Array)
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]==$Value
            ?   Index
            :   _FindEQFirst(Index+1,Element)
        :   $Array[Index]==$Value
            ?   Index
            :   _FindEQFirst(Index+1,Element)
;

function _FindEQLast(Index,Element)=
    Index<0
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]==$Value
            ?   Index
            :   _FindEQLast(Index-1,Element)
        :   $Array[Index]==$Value
            ?   Index
            :   _FindEQLast(Index-1,Element)
;

function _FindEQAll(Index,Result=[])=
    Index<0
    ?   Result==[]
        ?   undef
        :   Result
    :   is_list($Array[0])
        ?   $Array[Index][Element]==$Value
            ?   _FindEQAll(Index-1,Element,concat(Result,[Index]))
            :   _FindEQAll(Index-1,Element,Result)
        :   $Array[Index]==$Value
            ?   _FindEQAll(Index-1,Element,concat(Result,[Index]))
            :   _FindEQAll(Index-1,Element,Result)
;
