/*
  Find the first element in an array that is Greater Than a value.
*/
function FindGT(Value,Array,Type="First",Element=0)=
    let(
        /* Put some parameters in Special Variables, easier this way than putting them in the recursive calls. */
        $Array=Array,
        $Value=Value
    )
    Type=="First"
    ?   _FindGTFirst(0,Element)
    :   Type=="Last"
        ?   _FindGTLast(Len($Array),Element)
        :   _FindGTAll(Len($Array),Element)
;

/* Recursive helpers. */
function _FindGTFirst(Index,Element)=
    Index==len($Array)
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]>$Value
            ?   Index
            :   _FindGTFirst(Index+1,Element)
        :   $Array[Index]>$Value
            ?   Index
            :   _FindGTFirst(Index+1,Element)
;

function _FindGTLast(Index,Element)=
    Index<0
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]>$Value
            ?   Index
            :   _FindGTLast(Index-1,Element)
        :   $Array[Index]>$Value
            ?   Index
            :   _FindGTLast(Index-1,Element)
;

function _FindGTAll(Index,Result=[])=
    Index<0
    ?   Result==[]
        ?   undef
        :   Result
    :   is_list($Array[0])
        ?   $Array[Index][Element]>$Value
            ?   _FindGTAll(Index-1,Element,concat(Result,[Index]))
            :   _FindGTAll(Index-1,Element,Result)
        :   $Array[Index]>$Value
            ?   _FindGTAll(Index-1,Element,concat(Result,[Index]))
            :   _FindGTAll(Index-1,Element,Result)
;
