/*
  Find the first element in an array that is Greater Than or Equal to a value.
*/
function FindGTE(Value,Array,Type="First",Element=0)=
    let(
        /* Put some parameters in Special Variables, easier this way than putting them in the recursive calls. */
        $Array=Array,
        $Value=Value
    )
    Type=="First"
    ?   _FindGTEFirst(0,Element)
    :   Type=="Last"
        ?   _FindGTELast(Len($Array),Element)
        :   _FindGTEAll(Len($Array),Element)
;

/* Recursive helpers. */
function _FindGTEFirst(Index,Element)=
    Index==len($Array)
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]>=$Value
            ?   Index
            :   _FindGTEFirst(Index+1,Element)
        :   $Array[Index]>=$Value
            ?   Index
            :   _FindGTEFirst(Index+1,Element)
;

function _FindGTELast(Index,Element)=
    Index<0
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]>=$Value
            ?   Index
            :   _FindGTELast(Index-1,Element)
        :   $Array[Index]>=$Value
            ?   Index
            :   _FindGTELast(Index-1,Element)
;

function _FindGTEAll(Index,Result=[])=
    Index<0
    ?   Result==[]
        ?   undef
        :   Result
    :   is_list($Array[0])
        ?   $Array[Index][Element]>=$Value
            ?   _FindGTEAll(Index-1,Element,concat(Result,[Index]))
            :   _FindGTEAll(Index-1,Element,Result)
        :   $Array[Index]>=$Value
            ?   _FindGTEAll(Index-1,Element,concat(Result,[Index]))
            :   _FindGTEAll(Index-1,Element,Result)
;
