/*
  Find the first element in an array that is Greater Than or Equal to a value.
*/
function FindLT(Value,Array,Type="First",Element=0)=
    let(
        /* Put some parameters in Special Variables, easier this way than putting them in the recursive calls. */
        $Array=Array,
        $Value=Value
    )
    Type=="First"
    ?   _FindLTFirst(0,Element)
    :   Type=="Last"
        ?   _FindLTLast(Len($Array),Element)
        :   _FindLTAll(Len($Array),Element)
;

/* Recursive helpers. */
function _FindLTFirst(Index,Element)=
    Index==len($Array)
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]<$Value
            ?   Index
            :   _FindLTFirst(Index+1,Element)
        :   $Array[Index]<$Value
            ?   Index
            :   _FindLTFirst(Index+1,Element)
;

function _FindLTLast(Index,Element)=
    Index<0
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]<$Value
            ?   Index
            :   _FindLTLast(Index-1,Element)
        :   $Array[Index]<$Value
            ?   Index
            :   _FindLTLast(Index-1,Element)
;

function _FindLTAll(Index,Result=[])=
    Index<0
    ?   Result==[]
        ?   undef
        :   Result
    :   is_list($Array[0])
        ?   $Array[Index][Element]<$Value
            ?   _FindLTAll(Index-1,Element,concat(Result,[Index]))
            :   _FindLTAll(Index-1,Element,Result)
        :   $Array[Index]<$Value
            ?   _FindLTAll(Index-1,Element,concat(Result,[Index]))
            :   _FindLTAll(Index-1,Element,Result)
;
