/*
  Find element/s in an array that is/are Greater Than or Equal to a value.
*/
function FindLTE(Value,Array,Type="First",Element=0)=
    let(
        /* Put some parameters in Special Variables, easier this way than putting them in the recursive calls. */
        $Array=Array,
        $Value=Value
    )
    Type=="First"
    ?   _FindLTEFirst(0,Element)
    :   Type=="Last"
        ?   _FindLTELast(Len($Array),Element)
        :   _FindLTEAll(Len($Array),Element)
;

/* Recursive helpers. */
function _FindLTEFirst(Index,Element)=
    Index==len($Array)
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]<=$Value
            ?   Index
            :   _FindLTEFirst(Index+1,Element)
        :   $Array[Index]<=$Value
            ?   Index
            :   _FindLTEFirst(Index+1,Element)
;

function _FindLTELast(Index,Element)=
    Index<0
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]<=$Value
            ?   Index
            :   _FindLTELast(Index-1,Element)
        :   $Array[Index]<=$Value
            ?   Index
            :   _FindLTELast(Index-1,Element)
;

function _FindLTEAll(Index,Result=[])=
    Index<0
    ?   Result==[]
        ?   undef
        :   Result
    :   is_list($Array[0])
        ?   $Array[Index][Element]<=$Value
            ?   _FindLTEAll(Index-1,Element,concat(Result,[Index]))
            :   _FindLTEAll(Index-1,Element,Result)
        :   $Array[Index]<=$Value
            ?   _FindLTEAll(Index-1,Element,concat(Result,[Index]))
            :   _FindLTEAll(Index-1,Element,Result)
;
