/*
  Find the first element in an array that is Equal to a value.
*/
function FindNE(Value,Array,Type="First",Element=0)=
    let(
        /* Put some parameters in Special Variables, easier this way than putting them in the recursive calls. */
        $Array=Array,
        $Value=Value
    )
    Type=="First"
    ?   _FindNEFirst(0,Element)
    :   Type=="Last"
        ?   _FindNELast(Len($Array),Element)
        :   _FindNEAll(Len($Array),Element)
;

/* Recursive helpers. */
function _FindNEFirst(Index,Element)=
    Index==len($Array)
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]!=$Value
            ?   Index
            :   _FindNEFirst(Index+1,Element)
        :   $Array[Index]!=$Value
            ?   Index
            :   _FindNEFirst(Index+1,Element)
;

function _FindNELast(Index,Element)=
    Index<0
    ?   undef
    :   is_list($Array[0])
        ?   $Array[Index][Element]!=$Value
            ?   Index
            :   _FindNELast(Index-1,Element)
        :   $Array[Index]!=$Value
            ?   Index
            :   _FindNELast(Index-1,Element)
;

function _FindNEAll(Index,Result=[])=
    Index<0
    ?   Result==[]
        ?   undef
        :   Result
    :   is_list($Array[0])
        ?   $Array[Index][Element]!=$Value
            ?   _FindNEAll(Index-1,Element,concat(Result,[Index]))
            :   _FindNEAll(Index-1,Element,Result)
        :   $Array[Index]!=$Value
            ?   _FindNEAll(Index-1,Element,concat(Result,[Index]))
            :   _FindNEAll(Index-1,Element,Result)
;
