/*
  Get a value from a Key-Value array. The Key-Value array consists of Key-Value pairs or Key-Value lists with multiple values. Element specifies the requested value from the list if applicable.
  Key: Key to look for.
  KeyValueArray: either of:
  * [[Key0, Value0],[Key1, Value1],...].
  * [[Key0, Value0.0, Value0.1,...],[Key1, Value1.0, Value1.1,...],...].
  * Element=1 is the first Value in the list.
*/
/*
  GetValue() is the newer, 'more better' version of the legacy 'FindValue()' which is iterative.
*/
function GetValue(Key,KeyValueArray,Element=1)=
    let(
        /* Look for 'Key' in 0-element of sub-lists, return only one (there should be no more than _one_ unique Key. */
        /* Placing *Key* in [] means strings don't get interpreted as a list of characters. _search()_ is powerful, but you have to pay attention if you want to get what you're looking for... */
        Result=search([Key],KeyValueArray,1,0)
    )
    Result==undef
    ?   undef
    :   KeyValueArray[Result[0]][Element]
;

