/*
  On 1e6 operations, it's more than twice as fast to do 4 searches of a 10 item list, than it is to do 10 searches of a 4 item list. That's not a surprising result, but it's worth mentioning.
*/
/* Returns the intersection of two arrays, i.e., the list of items that are in both arrays. */
function Intersection(Array1,Array2)=
    len(Array1)<len(Array2)
    ?   [
            for(Key=Array1)
                if(undef!=search(Key,Array2)[0])
                    Key
        ]
    :   [
            for(Key=Array2)
                if(undef!=search(Key,Array1)[0])
                    Key
        ]
;
