/*
  Similar to 'GetValue()' but where 'GetValue()' uses Key-Value pairs or lists in a single array, 'Match()' uses two separate arrays, a Key-array and a Result-array.
  Key: Key to look for.
  KeyArray, ValueArray: arrays of values.
*/
function Match(Key,KeyArray,ValueArray,Element=0)=
    let(
        Index=search(Key,KeyArray),
        Result=len(ValueArray[Index[0]])==undef
        /* Result is a single value, not a list. 'Element' is ignored. */
        ?   ValueArray[Index[0]]
        :   ValueArray[Index[0]][Element]
    )
    Index==undef
    ?   undef
    :   Result
;
