/*
  Quick searching routine for ORDERED arrays.

  This routine performs 5x faster than a regular 'walk through' search.
  The reason? It halves the number of possibilities with each step, for example it searches a 1e3 element array in under 10 steps (2^10=1024).

  It is only _slightly_ slower than the native search() =/

  Yes. Of course you should use search()...

*/
function QuickFind(Value,Array)=
    let(
        End=Len(Array),
        /* Keep Array and Value out of the recursive call. */
        $Array=Array,
        $Value=Value
    )
    Value==Array[0]
    ?   0
    :   Value==Array[End]
        ?   End
        :   _QF(0,End)
;

function _QF(Lo,Hi)=
    let(
        /* grab the middle. */
        Mid=floor((Lo+Hi)/2)
    )
    /* There is no *Value* in *Array* when *Mid* becomes equal to *Lo*. */
    Mid==Lo
    ?   undef
    :   $Array[Mid]==$Value
        ?   Mid
        /* discard the invalid half, set new search range and try again. */
        :   $Array[Mid]<$Value
            ?   _QF(Mid,Hi)
            :   _QF(Lo,Mid)
;
