/*
  Quick sorting routine. Recursive. Works with 1D or 2D (i.e. vertices) arrays.
  Sort by element of 2D item, i.e. sort by y-value, or z-value etc.
*/
function QuickSort(Array,Element=undef)=
    len(Array)<2
    ?   Array
    :   let(
            Center=undef==Element
            ?   Array[floor(len(Array)/2)]
            :   Array[floor(len(Array)/2)][Element],
            Less=undef==Element
            ?   [for(Item=Array) if(Item<Center) Item]
            :   [for(Item=Array) if(Item[Element]<Center) Item],
            Equal=undef==Element
            ?   [for(Item=Array) if(Item==Center) Item]
            :   [for(Item=Array) if(Item[Element]==Center) Item],
            Greater=undef==Element
            ?   [for(Item=Array) if(Item>Center) Item]
            :   [for(Item=Array) if(Item[Element]>Center) Item]
        )
    concat(QuickSort(Less,Element),Equal,QuickSort(Greater,Element))
;
