/*
    Even though it's name implies different, RemoveDoubles() gets rid of any number of consecutive identical elements in Array. This is required after concat() of e.g. curve segments as end and start points of successive curve segments may be identical.

    Note:   This routine also removes the last value Array[n] if it is identical to Array[0].
 */
function RemoveDoubles(Array)=
    Array[0]==Array[Len(Array)]
    /* Start and End are identical, drop End. */
    ?   _RemoveDoubles(Array,Len(Array)-2,[Array[Len(Array)-1]])
    /* Keep the tail. */
    :   _RemoveDoubles(Array,Len(Array)-1,[Array[Len(Array)]])
;

function _RemoveDoubles(Array,Index,Result)=
        Index<0
        /* We're done. */
        ?   Result
        :   Array[Index]!=Result[0]
            /* No double; add it to Result. */
            ?   _RemoveDoubles(Array,Index-1,concat([Array[Index]],Result))
            /* Double; drop this one. */
            :   _RemoveDoubles(Array,Index-1,Result)
;
