/*
  Removes all but the first occurrence of an element from an array.

  Also works for strings, but the result will always be an array; if you want to remove identicals from a string and get a string as the result, simply do:

  MyResult=TupletoString(RemoveRepeated(MyString));

  echo(RemoveRepeated("Abracadabra"));
  ECHO: ["A", "b", "r", "a", "c", "d"]

  echo(TupleToString(RemoveRepeated("Abracadabra")));
  ECHO: "Abracd"
*/
function RemoveRepeated(Array)=
    /* we stumble over 'empties'... */
    (Array=="")||(Array==[])?[]:
    let(
        /* List all first occurrences. */
        FirstLocations=[
            for(Idex=[0:Len(Array)])
                search(Array[Idex],Array)[0]
        ]
    )
    RemoveUndefs([
        /* When first index equals current index, this is the first occurrence, undef the rest and clean 'r up. */
        for(Jdex=[0:Len(Array)])
        Jdex==FirstLocations[Jdex]
        ?   Array[Jdex]
        :   undef
    ])
;

