/*
    Remove successive identical elements in an array. This is required after concat() of e.g. curve segments as end and start points of successive curve segments may be identical.

    Note:   Unlike RemoveDoubles(), this routine DOES NOT remove the last value Array[n] if it is identical to Array[0].
 */
function RemoveSuccessive(Array)=
    _RemoveSuccessive(Array,Len(Array)-1,[Array[Len(Array)]])
;

function _RemoveSuccessive(Array,Index,Result)=
        Index<0
        /* We're done. */
        ?   Result
        :   Array[Index]!=Result[0]
            /* No double; add it to result. */
            ?   _RemoveSuccessive(Array,Index-1,concat([Array[Index]],Result))
            /* Double; drop this one. */
            :   _RemoveSuccessive(Array,Index-1,Result)
;
