/* Scale an array of vertices by different factors for each dimension. An array can be scaled in _all dimensions equally_ by simple multiplication with a scalar like 'Brray=3*Array' */
function ScaleArray(Array,ScaleVector)=
    let(
        Length=Len(Array[0])
    )
    Length!=Len(ScaleVector)?undef:
    [
        for(Vertex=Array)
        [
            for(I=[0:Length])
            Vertex[I]*ScaleVector[I]
        ]
    ]
;

function ScaleVector(Vector,ScaleVector)=
    Len(Vector)!=Len(ScaleVector)?undef:
    [
        for(I=[0:Len(Vector)])
        Vector[I]*ScaleVector[I]
    ]
;

