/*
  Reduce the order (depth) of an array to 1.
  Used to reduce an array of arrays of points to a single array of points.
  Arrays inside *Array* may be of any (mixed) order.

    This:

        K=[
            [0,1],
            [[[1,2]],[1,2]],
            [[2,3],[[3,4],[3,4]]],
            [[[4,5]]]
        ];

        echo(K);

        echo(SmashArray(K,0));

    Yields: (spaced for clarity)

        ~ECHO: [[0,1], [[[1,2]], [1,2]], [[2,3], [[3,4], [3,4]]], [[[4,5]]]]
        ~ECHO: [[0,1],   [1,2],  [1,2],   [2,3],  [3,4], [3,4],     [4,5]]

*/
function SmashArray(Array,Index)=
    let(Length=Len(Array))
    Index==Length+1
    /* We're done. */
    ?   Array
        :   is_list(Array[Index][0])
            /* Current element contains list(s). */
            ?   SmashArray(
                    concat(
                        Index==0
                        /* Current element is first, no previous. */
                        ?   []
                        /* Previous elements (already processed). */
                        :   [for(I=[0:Index-1])Array[I]],
                        /* Current element loses outer brackets. */
                        Array[Index],
                        Index==Length
                        /* Current element is last, no remainder. */
                        ?   []
                        /* Remainder of *Array*. */
                        :   [for(I=[Index+1:Length])Array[I]]
                    ),
                /* Index remains the same to point at new current element. */
                Index)
                /* Current element contains no list(s), check next. */
            :   SmashArray(Array,Index+1)
;
