/*
  An array [0...Value] in segments the size of *Step* (defaults to $fs). The first and last values in the array are ALWAYS _0_ and *Value*.
  *Step* will be adjusted so that all steps are of one, equal size. If *Step* is negative, there will be abs(Step) steps (and thus *Steps*+1 values).
*/
function Stepped(Value,Step=$fs)=
    let(
        Steps=Step>0
        ?   round(Value/Step)
        :   abs(Step)
    )
    [ for(Sdex=[0:Steps]) Value*Sdex/Steps ]
;
