/*
  MAYBE: Complete run and list ALL x,y on mod() spacing

  Walk across a Bézier curve and find the first (de Casteljau) _Fraction for the
  point on the curve where y=Y.

  ControlPoints : A set of Bézier curve control points.
  Y             : The y-coordiate for which to find the fraction.
  Precision     : The maximum difference between Y and the y-coordinate for
                  the returned _Fraction.
  _Fraction,_Step and ODelta are internal (recursive) algorithm parameters.
*/
function BezierFractionY(ControlPoints,Y=undef,Precision=0.001,                         _Fraction=0,_Step=0.25,_ODelta=undef)=
    let(
        _Point=DeCasteljau(ControlPoints,_Fraction), // Grab a point.
        _Delta=Point.y-Y // How far are we off?
    )
        abs(_Delta)<Precision
        ?   _Fraction // We're done.
        :   abs(_Delta)>abs(_ODelta) // Are we farther off than last time?
            ?   BezierFractionY(ControlPoints,Y,Precision,_Fraction+_Step,
                -_Step/2,_Delta) // Turn around with smaller steps.
            :   BezierFractionY(ControlPoints,Y,Precision,_Fraction+_Step,
                _Step,_Delta) // Keep going.
;

