/*
  Yes, just an alias. No, I'm not going to get rid of DeCasteljau(). If you must know, I think Mr. Paul de Castejau deserves to be recognised for his achievement. If you think I'm being silly, well, you've got the code, hack away.
*/
/*
  CPS : Contol Point Set.
*/
function BezierVertex(ControlPoints,Fraction)=
    DeCasteljau(ControlPoints,Fraction)
;

function BezierCubic(CP,Resolution=20,Fraction=1)=
    let(
        Steps=Fraction*(Resolution-1)
    )
    [
        for(Step=[0:Steps])
            CBezierVertex(CP,Step/Steps)
    ]
;

function BezierQuadratic(CP,Resolution=20,Fraction=1)=
    let(
        Steps=Fraction*(Resolution-1)
    )
    [
        for(Step=[0:Steps])
            QBezierVertex(CP,Step/Steps)
    ]
;

/*
  The explicit cubic version in Bernstein polynomal form.
  * Twice as fast as DeCasteljau().
  * The first factor in the iterations, here [1,3,3,1] are the binomial coefficients (from Pascal's triangle). If you'd like to write an explicit function for, say 6 control point curves, grab the 'BiCos' with:
  ~echo(BiCoRow(6)); The other factors are just consecutive, as you can see.
  * Each iteration is written out completely (even the pow(...,0) factors) to show the pattern.

function CBezierVertex(CPS,Fraction)=
    1 * pow((1-Fraction),3) * pow(Fraction,0) * CPS[0] +
    3 * pow((1-Fraction),2) * pow(Fraction,1) * CPS[1] +
    3 * pow((1-Fraction),1) * pow(Fraction,2) * CPS[2] +
    1 * pow((1-Fraction),0) * pow(Fraction,3) * CPS[3]
;

*/
/*  The pow(..,0) and pow(..,1) are solved here; your poor CPU has enough to think about already.
*/
function CBezierVertex(ControlPoints,Fraction)=
    1 * pow((1-Fraction),3) *         1       * ControlPoints[0] +
    3 * pow((1-Fraction),2) *     Fraction    * ControlPoints[1] +
    3 *     (1-Fraction)    * pow(Fraction,2) * ControlPoints[2] +
    1 *            1        * pow(Fraction,3) * ControlPoints[3]
;

/*
  The explicit quadratic version, just in case...
*/
function QBezierVertex(ControlPoints,Fraction)=
    1 * pow((1-Fraction),2) *         1       * ControlPoints[0] +
    2 *     (1-Fraction)    *     Fraction    * ControlPoints[1] +
    1 *            1        * pow(Fraction,2) * ControlPoints[2]
;

//--- Abandon all hope, ye who enter here; here, there be dragons... -----------

/*
  Generate a point on a Bézier curve.
  CPS : A set of Bézier curve control points.
  Fraction     : The fraction [0:1] of the curve where to calculate the point.

  Do NOT use this for Bézier Curves of *known* degree, write a new explicit routine like the ones above, your CPU will be grateful.

  This is the *general case* Bernstein polynomial form of the curve equation. It is very computationally expensive because of the Binomial Coefficient calculations. It takes almost 2.5 times as long as DeCasteljau() for a cubic Bézier Curve. I haven't bothered to check higher order ones, because:

  Just use DeCasteljau() for general cases. This is just here for completeness, or if you want to punish your processor.
*/
function GenBezierVertex(CPS,Fraction)=
    _GenBezierVertex(CPS,Fraction,Len(CPS),0,[0,0,0])
;

function _GenBezierVertex(CP,T,N,I,Point)=
    I==N+1
    ?   Point
    :   _GenBezierVertex(CP,T,N,I+1,BinomialCoefficient(N,I)*pow(T,I)*pow(1-T,N-I)*CP[I]+Point)
;

/* A slightly different approach, but only 1.5% faster (on 1e5 operations) compared to GenBezierVertex(). */
function GBezierVertex(CPS,Fraction)=
    let(
        N=Len(CPS),
        BiCos=BiCoRow(N+1)
    )
    ArraySum(
        [   for(Idex=[0:N])
            BiCos[Idex]*pow((1-Fraction),N-Idex)*pow(Fraction,Idex)*CPS[Idex]
        ]
    )
;

