/*
  Generate a point on a _single_ Bézier curve. See 'ShowDeCasteljau()'.
  CP:       A Bézier Control Polygon, e.g., [[CP0],[CP1],[CP2],[CP3]].
  Fraction: The fraction [0:1] of the curve where to calculate the point.

  NOTE: If fed a list of lists of vertices, e.g., if fed a list of (closed) curves, DeCasteljau() will use each curve as a 'control curve', and return the _curve_ that lies between them, as opposed to the _vertex_ a 'normal' control-polygon would have yielded...
*/
function DeCasteljau(CPS,Fraction)=
    (len(CPS) == 2) // We're down to one pair of points.
    ?   Fraction*CPS[1] + (1-Fraction)*CPS[0]
    :   DeCasteljau( // Do it again...
        [
            for(i=[0:len(CPS)-2])
                Fraction*CPS[i+1] + (1-Fraction)*CPS[i]
        ],
        Fraction
    )
;

