/*
  Show a Bézier Curve Tangent Point Array.

  This is only useful for display (in the documentation) and troubleshooting purposes, perhaps...

  Sets   : tuple of the sets to display, _undef_ for all sets.
  Points : as for *Sets*.

    _undef_ shows all, [] shows none, and [n1,n3] shows those mentioned.

  TODO: Vertices or Curves selectors.
*/
module ShowTPA(TPA,Sets=undef,Points=undef,Vectors=undef,Curves=undef,Radius=0.2,Thickness=0.3,Resolution=10,Connect=true,CColor=MGT,CAlpha=1,PColor=DSG,PAlpha=1,VAlpha=1){

    _Sets=undef==Sets
    ?   RangeToTuple([0:Len(TPA)])
    // Let's not answer silly requests.
    :   Intersection(Sets,RangeToTuple([0:Len(TPA)]));

    for(Idex=_Sets)
        let(
            // Create the tangent vector set, for the vectors, obvs...
            TVS=BezierTangentVectorSet(TPA[Idex]),
            // The Control polygons for the curves.
            CPS=BezierControlPolygonSet(TVS),
            // Error trap for nonsense requests. These are done here and not with Sets, outside the for() call, in case we are able to process unequal-length sets in the future.
            _Curves=undef==Curves
            ?   RangeToTuple([0:Len(CPS[0])])
            :   Intersection(Curves,RangeToTuple([0:Len(CPS[0])])),
            _Points=undef==Points
            ?   RangeToTuple([0:Len(TVS)])
            :   Intersection(Points,RangeToTuple([0:Len(TVS)])),
            _Vectors=undef==Vectors
            ?   RangeToTuple([0:Len(TVS)])
            :   Intersection(Vectors,RangeToTuple([0:Len(TVS)]))
        ){
        for(Jdex=_Curves){
            color(CColor,CAlpha)
            BezierCurve(CPS[0][Jdex],Resolution,false,true,Thickness/2,1,Connect);
        }
        for(Kdex=_Vectors){
            // Show me those pretty things...
            // Forward magnitude.
            color(RED,VAlpha)
            translate(TVS[Kdex][0])
            Arrow(TVS[Kdex][1],[0,0.3,1],Thickness);
            // Reverse magnitude.
            color(BLU,VAlpha)
            translate(TVS[Kdex][0])
            Arrow(TVS[Kdex][2],[0,0.3,1],Thickness);
            // Next magnitude, if it exists.
            if(undef!=TVS[Kdex][3])
            color(GRN,VAlpha)
            translate(TVS[Kdex][0])
            Arrow(TVS[Kdex][3],[0,0.3,1],Thickness);
            // Previous magnitude, if it exists.
            if(undef!=TVS[Kdex][4])
            color(YLW,VAlpha)
            translate(TVS[Kdex][0])
            Arrow(TVS[Kdex][4],[0,0.3,1],Thickness);
        }
        for(Ldex=_Points){
            color(PColor,PAlpha)
            translate(TVS[Ldex][0])
            sphere(Radius);
        }
    }
}

