/*
  An angled line in Z=0 through the origin.
*/
module ALine(Angle,Thickness=0.05,2D=false){

    if(2D&&(Len(Angle)==undef)){
        rotate([0,0,Angle])
        translate([-5000,-Thickness/2,-Smidge])
        cube([10000,Thickness,Smidge]);
    }else{
        rotate(Len(Angle)==2?Angle:[0,0,Angle])
        CylinderBetween(
            [-5000,0,0],[5000,0,0],Thickness/2
            // Use $fc--if set--to construct the curve, i.e., for the curve's elements, or the 'default' number of segments otherwise.
            ,$fn=$fc==0
            ?   Segments(Radius,$fn=0) // $fn=0 here 'disables' $fn in Segments().
            :   $fc
        );
    }

}

/* TODO: All 'line' modules need pattern like Arc() has. */

