/*
  An Arc() is NOT a Circle().
  * Assumes we're building a shape or something similas, thus default is 2D.
*/
function Arc(StartAngle,EndAngle,Radius,FullEnds=true,3D=false)=
    let(
        Angles=ArcAngles(StartAngle,EndAngle,Radius),
        Alpha=180/Segments(Radius), // Half the segment angle.
        Steps=Len(Angles)-1
    )
    // Arcs are NOT circles.
    Map360(EndAngle-StartAngle)==0?Alert(["Overlapping ends in Arc()"],undef):
    // Arcs and circles are really n-gons, made up of segments. If *FullEnds*==true, start and end points are at FULL *Radius*, regardless of whether they lie on a proper n-gon corner point, or somewhere in between, i.e., this gives 'deformed' ends to the n-gon arc, however, they would join up with tangential lines to the 'theoretical' curve in that point (which the unsuspecting user might expect to be at full radius)...
    FullEnds
    ?   [
            for (Angle=Angles)
                [
                    Radius*cos(Angle),
                    Radius*sin(Angle),
                    if(3D)0
                ]
        ]
    //  *FullEnds*=false; start and end points are located on the segment line proper when they are somewhere between two of the n-gon corners, i.e., we're literally cutting a segment from the n-gon.
    :   [
            PolarToVector([Radius*cos(Alpha)/cos(Alpha-(Angles[1]+360-StartAngle)%360),if(3D)90,StartAngle]),
            // Intermediate points only exist if there is more than one segment, i.e., len(Angles)>=3.
            if (Steps>=1) for(I=[1:Steps])
                [
                    Radius*cos(Angles[I]),
                    Radius*sin(Angles[I]),
                    if(3D)0
                ],
            PolarToVector([Radius*cos(Alpha)/cos(-Alpha+EndAngle-Angles[len(Angles)-2]),if(3D)90,EndAngle]),
        ]
;

/*
  Pattern is dash-dot pattern in unit line lengths, like [5,10] for 5 unit lines with 10 unit gaps, or [3,2,1,2] &c. The Pattern[0] and Pattern[even] elements are lines, the Pattern[odd] elements are gaps.
*/
module Arc(StartAngle,EndAngle,Radius,Thickness,Pattern=undef,FullEnds=true){
    Angle=Map360(EndAngle-StartAngle);
    // Arcs are NOT circles.
    if(Angle==0){ // If fed 0,360 or two 'identical' angles, e.g., -30,330.
        Alert(["Overlapping ends in Arc() module."]);
    }else{
        // Proper arc, no dash-dot pattern.
        if(Pattern==undef){
/*            rotate([0,0,StartAngle])
            rotate_extrude(angle=Angle)
            translate([Radius,0])
            // The curve _element_, i.e., not the curve itself, is formed here.
            circle(r=Thickness/2,
                $fn=$fc==0
                ?   Segments(Radius,$fn=0) // $fn=0 ensures proper 'standard' segment Nos.
                :   $fc
            ); */
            ShowCurve(Arc(StartAngle,EndAngle,Radius,FullEnds,true),Thickness/2);
        }else{
/* TODO: Do this with rotate_extrude instead? */
            /* Dash-dot or whatever pattern line.. */
            /* NO error checks here, but lots of room for mess-ups. */
            /* We no longer care about *FullEnds* and such, we're just drawing lines for an image or 'drawing' (OpenSCAD ain't no AutoCAD). */
            PatternAngle=ArraySum(Pattern/Radius/Tau*360);
            Alert(["Pattern too large for arc angle in Arc().",],PatternAngle>Angle);
            PatternCount=max(round(Angle/PatternAngle),1);
            /* If len(Pattern) is even (pattern ends with a 'gap') and the arc is less than a full circle, Pattern[0] is added to the end of the last pattern, so that the arc ends with a line segment and not a gap (which would leave the end of the line 'undefined'). */
            EndFill=(Angle<360&&IsEven(len(Pattern))?Pattern[0]/Radius/Tau*360:0);
            /* Adjust pattern fit and convert to angles. */
            PatternFactor=Angle/(PatternAngle*PatternCount+EndFill);
            Fattern=Pattern*PatternFactor/Radius/Tau*360;
            FatternAngle=ArraySum(Fattern);
            /* Rotate the arc-start to the start-angle position. */
            rotate([0,0,StartAngle-(Angle==360?Fattern[0]/2:0)]){
                /* Draw the arc. */
                for(Idex=[0:PatternCount-1])
                    for(Jdex=[0:Len(Fattern)])
                        if(IsEven(Jdex))
                            let(Start=Idex*FatternAngle+(Jdex>0?ArraySum(Fattern,0,Jdex-1):0))
                            Arc(Start,Start+Fattern[Jdex],Radius,Thickness,undef,true);
                /* Add the 'end-defining' line segment, see comment above. */
                if(Angle<360&&IsEven(len(Pattern)))
                    Arc(PatternCount*FatternAngle,PatternCount*FatternAngle+Fattern[0],Radius,Thickness,undef,true);
            }
        }
    }
}
