/*
  Divide an arc into segments and return the segment angles as a tuple.
  Angle: degrees, arc size.
  Segments: number of arc-segments for the division of *Angle*, leave _undef_ to divide the arc in *$fn*-size segments

  echo(ArcAngles(0,30,$fn=36));// $fn=36 so segments will be 360/36=10 degrees.
  ECHO: [0,10,20,30]

  * Arcs _always_ run CCW. Zero degrees is--of course--on the X-axis.
*/
function ArcAngles(StartAngle=0,EndAngle=360,Radius)=
    let(
        // Bring both values within [0, 360].
        Start=Map360(StartAngle),
        End=Map360(EndAngle),
        // Get the 'default' angles for this radius.
        ANG=CircleAngles(Radius)
    )
    // Arcs are NOT circles:
    Start==End?Alert(["Overlapping ends in ArcAngles()"],undef):
    Start<End
    ?   [
            Start,
            for(A=ANG)
                if(A>Start && A<End)
                    A,
            End
        ]
    // If Start>End, zero lies in-between...
    :   [
            Start,
            for(A=ANG)
                if(A>Start)
                    A,
            for(A=ANG)
                if(A<End)
                    A,
            End
        ]
;

