/*
  Returns the length of a curve (array of vertices), open or closed.
*/

function CurveLength(Curve,Closed=false)=
    let(
        N=Len(Curve),
        Lengths=
        [
            // Each element contains the distance to the next.
            for(Idex=[0:N-1])
            Modulus(Curve[Idex+1]-Curve[Idex]),
            // The last element contains the 'closing distance' of the curve.
            Modulus(Curve[0]-Curve[N])
        ]
    )
    ArraySum(Lengths,0,N-(Closed?0:1))
;
