/* TODO: offset for solids like the boat create outer hull polygons, then add offsets starting at the last polygon so order of polygons is up, in and down like a tubular-ish... Then create end surface. */
/* TODO: look-ahead [0] and look behind [Len()-1] to get more consistent behaviour at the respective ends for OffsetAcute and OffsetObtuse cases. */

/* CurveOffset really only makes sense for CurveOffsetLeft and CurveOffsetRight, the others are only here for Feng Shui resons. */
/*
  For more info, see the documentation in Bisect.scad, also in this directory.
  Add a vector of length 'Dist' to V2, in the direction bisecting the _acute angle_ formed by V1-V2-V3.
*/

/* This will give silly results. Maybe you like silly. */
function CurveOffsetAcute(Curve,Dist,Closed=true)=
    let(
        Length=Len(Curve)
    )
    Closed
    ?
        /* Add a vector of length 'Dist' to Curve[Index], bisecting the line segments to the previous and the next vertex. */
        [
            BisectAcute(Curve[Length],Curve[0],Curve[1])*Dist+Curve[0],
            for(Index=[1:Length-1])
            BisectAcute(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            BisectAcute(Curve[Length-1],Curve[Length],Curve[0])*Dist+Curve[Length]
        ]
    :
        /* As for the closed case, but use the end-segments themselves for end-offsets as opposed to the previous and next points, as the endpoints of an open curve obviously don't coincide... :-/ */
       [
            LPerpVector(Curve[1]-Curve[0],Dist)+Curve[0],
            for(Index=[1:Length-1])
            BisectAcute(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            LPerpVector(Curve[Length]-Curve[Length-1],Dist)+Curve[Length],
        ]
;

/* This will give silly results. Maybe you like silly. */
function CurveOffsetObtuse(Curve,Dist,Closed=true)=
    let(
        Length=Len(Curve)
    )
    Closed
    ?
        /* Add a vector of length 'Dist' to Curve[Index], bisecting the line segments to the previous and the next vertex. */
        [
            BisectObtuse(Curve[Length],Curve[0],Curve[1])*Dist+Curve[0],
            for(Index=[1:Length-1])
            BisectObtuse(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            BisectObtuse(Curve[Length-1],Curve[Length],Curve[0])*Dist+Curve[Length]
        ]
    :
        /* As for the closed case, but use the end-segments themselves for end-offsets as opposed to the previous and next points, as the endpoints of an open curve obviously don't coincide... :-/ */
       [
            RPerpVector(Curve[1]-Curve[0],Dist)+Curve[0],
            for(Index=[1:Length-1])
            BisectObtuse(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            RPerpVector(Curve[Length]-Curve[Length-1],Dist)+Curve[Length],
        ]
;

/* Because CurveOffsetRight() makes the most sense as the default method, here's the default alias. */
function CurveOffset(Curve,Dist,Closed=true)=
    CurveOffsetRight(Curve,Dist,Closed)
;

/* For offsetting an entire array of vertices, like a polygon boundary. */
function CurveOffsetLeft(Curve,Dist,Closed=true)=
    let(
        Length=Len(Curve)
    )
    Closed
    ?
        /* Add a vector of length 'Dist' to Curve[Index], bisecting the line segments to the previous and the next vertex. */
        [
            BisectLeft(Curve[Length],Curve[0],Curve[1])*Dist+Curve[0],
            for(Index=[1:Length-1])
            BisectLeft(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            BisectLeft(Curve[Length-1],Curve[Length],Curve[0])*Dist+Curve[Length]
        ]
    :
        /* As for the closed case, but use the end-segments themselves for end-offsets as opposed to the previous and next points, as the endpoints of an open curve obviously don't coincide... :-/ */
       [
            LPerpVector(Curve[1]-Curve[0],Dist)+Curve[0],
            for(Index=[1:Length-1])
            BisectLeft(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            LPerpVector(Curve[Length]-Curve[Length-1],Dist)+Curve[Length],
        ]
;

/* For offsetting an entire array of vertices, like a polygon boundary. */
function CurveOffsetRight(Curve,Dist,Closed=true)=
    let(
        Length=Len(Curve)
    )
    Closed
    ?
        /* Add a vector of length 'Dist' to Curve[Index], bisecting the line segments to the previous and the next vertex. */
        [
            BisectRight(Curve[Length],Curve[0],Curve[1])*Dist+Curve[0],
            for(Index=[1:Length-1])
            BisectRight(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            BisectRight(Curve[Length-1],Curve[Length],Curve[0])*Dist+Curve[Length]
        ]
    :
        /* As for the closed case, but use the end-segments themselves for end-offsets as opposed to the previous and next points, as the endpoints of an open curve obviously don't coincide... :-/ */
       [
            RPerpVector(Curve[1]-Curve[0],Dist)+Curve[0],
            for(Index=[1:Length-1])
            BisectRight(Curve[Index-1],Curve[Index],Curve[Index+1])*Dist+Curve[Index],
            RPerpVector(Curve[Length]-Curve[Length-1],Dist)+Curve[Length],
        ]
;
