/*
  Returns the last vertex of the curve within 'Distance'.
*/// TODO round-ceil-floor function, make [0] the closed length &c.?
/* TODO: MODERNISE */
function FindCurveVertex(Curve,Distance,Closed=false)=
    let(
        Lth=len(Curve),
        Lengths=
        [
            for(Index=[1:Lth])
            // Each element contains the distance to the next.
            // The last element contains the 'closing distance' of the curve, i.e. the distance form the last vertex to the first. Dex() takes care of proper array indexing.
            let(
                Length=Curve[Dex(Index,Lth-1)]-Curve[Index-1]
            )
            sqrt(Length*Length) // Vector modulus.
        ],
        // Each element contains the total distance up to the NEXT element.
        // [len-1] is the CLOSED curve length, [len-2] is the OPEN curve length.
        Sums=[
            for(I=[0:Lth-1])
            ArraySum(Lengths,0,I)
        ],
        // For closed curves, did we make laps?
        Laps=Closed?floor(Distance/Sums[Lth-1]):0
    )
    !Closed&&Distance>Sums[Lth-2]
    ?   undef // We're past the end of an open curve.
    :   _FindCurveVertex(Sums,Distance%Sums[Lth-1],Laps*Lth,0)
;
// Find the node.
function _FindCurveVertex(Sums,Distance,Lapped,Index)=
        Distance<=Sums[Index] // The NEXT node is outside of Distance.
        ?   Index+Lapped // Return THIS node plus laps.
        :   _FindCurveVertex(Sums,Distance,Lapped,Index+1)
;
