/*
  A horizontal line at Y=...
*/
module HLine(Y,Thickness=0.05,2D=false){
    if(2D){
        translate([-5000,Y-Thickness/2,-Smidge])
        cube([10000,Thickness,Smidge]);
    }else{
        translate([-5000,Y,0])
        CylinderBetween(
            [-5000,0,0],[5000,0,0],Thickness/2
            // Use $fc--if set--to construct the curve, i.e., for the curve's elements, or the 'default' number of segments otherwise.
            ,$fn=$fc==0
            ?   Segments(Radius,$fn=0) // $fn=0 here 'disables' $fn in Segments().
            :   $fc
        );
    }

}

